'******************************************************************************
' DHCP routines (UDP required))
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile                                                  'will compile only as an include file

'-------------------------------------------------------------------------------
'  DHCP-packet filter
'-------------------------------------------------------------------------------
Sub Dhcp_packet_filter
Local Lw As Word
   If Dhcp_status = Dhcp_status_bound Then Exit Sub         'Don't accept packets anymore
   If Dhcp_b_opcode = Dhcp_op_bootreply Then
     If Dhcp_l_transaction_id = Dhcp_transaction_id Then
        Lw = Dhcp_find_option(53)
        If Lw = 0 Then Exit Sub
        Select Case Buffer(lw + 2)
           Case Dhcp_msg_type_dhcpoffer
              Call Dhcp_received_offer
           Case Dhcp_msg_type_dhcpack
              Call Dhcp_received_ack
           Case Dhcp_msg_type_dhcpnak
              Call Dhcp_received_nak
           Case Else
#if Debug_dhcp > 0
              Print
              Print "====================================================================="
              Print "  DHCP other packet received from IP ";
              Call Print_ip(ip_b_srcaddr(1) , No_crlf)
              Print " via MAC " ;
              Call Print_mac(eth_b_src_mac(1) , No_crlf)
              Print "---------------------------------------------------------------------"
#endif
#if Debug_dhcp > 2
              Call Eth_dump_header
              Call Ip_dump_header
              Call Udp_dump_header
              Call Dhcp_dump_frame
#endif
        End Select
     End If
  End If
End Sub

'-------------------------------------------------------------------------------
'  DHCP Initialization
'-------------------------------------------------------------------------------
Sub Dhcp_initialize
   Dhcp_status = Dhcp_status_init
#if Debug_dhcp > 1
  Print "  DHCP Status set to INIT"
#endif
   Call Dhcp_send_discover
End Sub

'-------------------------------------------------------------------------------
'  DHCP Every Minute
'-------------------------------------------------------------------------------
Sub Dhcp_every_minute
   Select Case Dhcp_renew_time                              'T1
      Case &HFFFFFFFF                                       'infinite
      Case Is > 0
         Dhcp_renew_time = Dhcp_renew_time - 60             '-60 secs
         If Dhcp_renew_time <= 0 Then
            Dhcp_status = Dhcp_status_renewing
#if Debug_dhcp > 1
            Print "  DHCP Status changed to RENEWING"
#endif
         End If
      Case Else
   End Select
   Select Case Dhcp_rebinding_time                          'T2
      Case &HFFFFFFFF                                       'infinite
      Case Is > 0
         Dhcp_rebinding_time = Dhcp_rebinding_time - 60     '-60 sec
         If Dhcp_rebinding_time <= 0 Then
            Dhcp_status = Dhcp_status_rebinding
#if Debug_dhcp > 1
            Print "  DHCP Status changed to REBINDING"
#endif
         End If
      Case Else
   End Select
   Select Case Dhcp_lease_time
      Case &HFFFFFFFF                                       'infinite
      Case Is > 0
         Dhcp_lease_time = Dhcp_lease_time - 60             '-60 sec
         If Dhcp_lease_time <= 0 Then
            Call Eeram_setup_network                        'reset to static network
            Dhcp_status = Dhcp_status_init
#if Debug_dhcp > 1
            Print "  DHCP Status changed to INIT"
#endif
         End If
      Case Else
   End Select
   Dhcp_secs_elapsed = Dhcp_secs_elapsed + 60

#if Debug_dhcp > 1
   Print
   Select Case Dhcp_status
      Case Dhcp_status_init
         Print "DHCP Status = INIT"
      Case Dhcp_status_renewing
         Print "DHCP Status = RENEWING"
      Case Dhcp_status_rebinding
         Print "DHCP Status = REBINDING"
      Case Dhcp_status_bound
         Print "DHCP Status = BOUND"
   End Select
   Print "  Renew Tmr = " ; Dhcp_renew_time
   Print " Rebind Tmr = " ; Dhcp_rebinding_time
   Print "  Lease Tmr = " ; Dhcp_lease_time
   Print "SecsElapsed = " ; Dhcp_secs_elapsed
#endif

   Select Case Dhcp_status
      Case Dhcp_status_bound
         Exit Sub
      Case Dhcp_status_init
         Call Dhcp_send_discover
      Case Else
         Call Dhcp_send_request
   End Select
End Sub

'-------------------------------------------------------------------------------
'  DHCP send Discover
'-------------------------------------------------------------------------------
Sub Dhcp_send_discover
Local Lw As Word
'Local Ls As String * 1
'Local Li As Integer
   Call Clear_buffer
   Lw = Dhcp_do_header(dhcp_msg_type_dhcpdiscover)

'Eth Header
   Eth_b_dest_mac(1) = &HFF                                 'destination MAC address
   Eth_b_dest_mac(2) = &HFF
   Eth_b_dest_mac(3) = &HFF
   Eth_b_dest_mac(4) = &HFF
   Eth_b_dest_mac(5) = &HFF
   Eth_b_dest_mac(6) = &HFF
'DHCP Frame
   Call Dhcp_create_new_xid()
   Dhcp_l_transaction_id = Dhcp_transaction_id
   Dhcp_w_flags = Dhcp_flags_broadcast
'DHCP Options'
   Incr Lw : Buffer(lw) = &HFF                              'end

   Call Ip_set_packet_length(lw)
   Call Ip_header_checksum
   Call Udp_set_packet_length(lw)
   Call Udp_checksum
   Call Enc28j60packetsend(lw)

#if Debug_dhcp > 0
   Print
   Print "====================================================================="
   Print "  DHCP Discover sent to IP ";
   Call Print_ip(ip_b_destaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_dest_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_dhcp > 2
   Call Eth_dump_header
   Call Ip_dump_header
   Call Udp_dump_header
   Call Dhcp_dump_frame
#endif
End Sub



'-------------------------------------------------------------------------------
'  DHCP Offer received
'-------------------------------------------------------------------------------
Sub Dhcp_received_offer
#if Debug_dhcp > 0
   Print
   Print "====================================================================="
   Print "  DHCP Offer received from IP ";
   Call Print_ip(ip_b_srcaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_src_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_dhcp > 2
   Call Eth_dump_header
   Call Ip_dump_header
   Call Udp_dump_header
   Call Dhcp_dump_frame
#endif
'  Call Dhcp_parse_options                                   '********** T E S T
  Call Dhcp_send_request
End Sub

'-------------------------------------------------------------------------------
'  Do Header
'-------------------------------------------------------------------------------
Function Dhcp_do_header(byval Msg_type As Byte) As Word
Local Lw As Word
Local Li As Byte
Local Ls As String * 1

   Eth_b_src_mac(1) = My_b_macaddr(1)
   Eth_b_src_mac(2) = My_b_macaddr(2)
   Eth_b_src_mac(3) = My_b_macaddr(3)
   Eth_b_src_mac(4) = My_b_macaddr(4)
   Eth_b_src_mac(5) = My_b_macaddr(5)
   Eth_b_src_mac(6) = My_b_macaddr(6)
   Eth_w_packettype = Eth_w_packettype_ip
'IP Header
   Ip_b_vers_and_length = Ip_standard_vers_and_length
   Ip_b_type_of_service = &H00
   Ip_w_identifier = Ip_get_next_identifier()
   Ip_w_fragmentation = &H0000
   Ip_b_time_to_live = 128
   Ip_b_protocol = Ip_protocol_udp

   Ip_b_srcaddr(1) = 0                                      'source address  --> 0.0.0.0
   Ip_b_srcaddr(2) = 0                                      'source address  --> 0.0.0.0
   Ip_b_srcaddr(3) = 0                                      'source address  --> 0.0.0.0
   Ip_b_srcaddr(4) = 0                                      'source address  --> 0.0.0.0
   Ip_b_destaddr(1) = 255                                   'destination IP --> 255.255.255.255
   Ip_b_destaddr(2) = 255                                   'destination IP --> 255.255.255.255
   Ip_b_destaddr(3) = 255                                   'destination IP --> 255.255.255.255
   Ip_b_destaddr(4) = 255                                   'destination IP --> 255.255.255.255
'UDP Header
   Udp_w_src_port = Udp_port_dhcp_local
   Udp_w_dest_port = Udp_port_dhcp_remote

   Dhcp_b_opcode = Dhcp_op_bootrequest
   Dhcp_b_hwtype = Dhcp_hwtype_eth10mb
   Dhcp_b_hwlen = 6
   Dhcp_b_hops = 0

   Dhcp_b_chaddr(1) = My_b_macaddr(1)
   Dhcp_b_chaddr(2) = My_b_macaddr(2)
   Dhcp_b_chaddr(3) = My_b_macaddr(3)
   Dhcp_b_chaddr(4) = My_b_macaddr(4)
   Dhcp_b_chaddr(5) = My_b_macaddr(5)
   Dhcp_b_chaddr(6) = My_b_macaddr(6)
   Dhcp_l_dhcp_cookie = Dhcp_cookie

   Dhcp_l_transaction_id = Dhcp_transaction_id


   Lw = Dhcp_options_start
   Buffer(lw) = Dhcp_opt_message_type                       'option  53
   Incr Lw : Buffer(lw) = 1                                 'Length
   Incr Lw : Buffer(lw) = Msg_type                          'Dhcp_request

   Incr Lw : Buffer(lw) = Dhcp_opt_parameter_request_list   'request for subnetmask, router and dns
   Incr Lw : Buffer(lw) = 5                                 'length
   Incr Lw : Buffer(lw) = 1                                 'Subnetmask
   Incr Lw : Buffer(lw) = 3                                 'Router
   Incr Lw : Buffer(lw) = 6                                 'Dns
   Incr Lw : Buffer(lw) = 12                                'Router
   Incr Lw : Buffer(lw) = 5                                 'Dns


'Hostame
   Incr Lw : Buffer(lw) = Dhcp_opt_hostname                 'set Hostname
   Incr Lw : Buffer(lw) = Len(my_s12_hostname)              'lengh of Option
   For Li = 1 To Len(my_s12_hostname)
      Ls = Mid(my_s12_hostname , Li , 1)
      Incr Lw : Buffer(lw) = Asc(ls)
   Next Li

   Dhcp_do_header = Lw
End Function

'-------------------------------------------------------------------------------
'  DHCP send Request
'-------------------------------------------------------------------------------
Sub Dhcp_send_request
Local Lw As Word
'Local Li As Integer
'Local Ls As String * 1
   If Dhcp_status > Dhcp_status_init Then
      Clear_buffer
   End If
   Lw = Dhcp_do_header(dhcp_msg_type_dhcprequest)
'Eth Header
   If Dhcp_status = Dhcp_status_renewing Then
      If Arp_request_destmac_for_ip(dhcp_b_recent_server_ip(1)) = Nok Then
         Exit Sub
      End If
   Else
      Eth_b_dest_mac(1) = &HFF                              'destination MAC address
      Eth_b_dest_mac(2) = &HFF
      Eth_b_dest_mac(3) = &HFF
      Eth_b_dest_mac(4) = &HFF
      Eth_b_dest_mac(5) = &HFF
      Eth_b_dest_mac(6) = &HFF
   End If

   If Dhcp_status = Dhcp_status_renewing Then
      Ip_b_srcaddr(1) = My_b_ipaddr(1)
      Ip_b_srcaddr(2) = My_b_ipaddr(2)
      Ip_b_srcaddr(3) = My_b_ipaddr(3)
      Ip_b_srcaddr(4) = My_b_ipaddr(4)
      Ip_b_destaddr(1) = Dhcp_b_recent_server_ip(1)
      Ip_b_destaddr(2) = Dhcp_b_recent_server_ip(2)
      Ip_b_destaddr(3) = Dhcp_b_recent_server_ip(3)
      Ip_b_destaddr(4) = Dhcp_b_recent_server_ip(4)
   End If



'DHCP frame
   If Dhcp_status > Dhcp_status_init Then
      Call Dhcp_create_new_xid()
   End If

   If Dhcp_status <= Dhcp_status_rebinding Then
      Dhcp_w_flags = Dhcp_flags_broadcast
   Else
      Dhcp_w_flags = Dhcp_flags_no_broadcast
   End If

   If Dhcp_status > Dhcp_status_init Then
      Dhcp_b_ciaddr(1) = My_b_ipaddr(1)
      Dhcp_b_ciaddr(2) = My_b_ipaddr(2)
      Dhcp_b_ciaddr(3) = My_b_ipaddr(3)
      Dhcp_b_ciaddr(4) = My_b_ipaddr(4)
   End If


'DHCP Options'
   Incr Lw : Buffer(lw) = 50                                'Option 50 --> suggested to wanted IP
   Incr Lw : Buffer(lw) = 4
   If Dhcp_status = Dhcp_status_init Then
      Incr Lw : Buffer(lw) = Dhcp_b_yiaddr(1)
      Incr Lw : Buffer(lw) = Dhcp_b_yiaddr(2)
      Incr Lw : Buffer(lw) = Dhcp_b_yiaddr(3)
      Incr Lw : Buffer(lw) = Dhcp_b_yiaddr(4)
   Else
      Incr Lw : Buffer(lw) = My_b_ipaddr(1)
      Incr Lw : Buffer(lw) = My_b_ipaddr(2)
      Incr Lw : Buffer(lw) = My_b_ipaddr(3)
      Incr Lw : Buffer(lw) = My_b_ipaddr(4)
   End If

   'six1 Client Identifier fr Anzeige Host-Name im Router!
   Incr Lw : Buffer(lw) = Dhcp_opt_client_identifier
   Incr Lw : Buffer(lw) = &H07
   Incr Lw : Buffer(lw) = Dhcp_opt_client_identifier_mac
   Incr Lw : Buffer(lw) = My_b_macaddr(1)
   Incr Lw : Buffer(lw) = My_b_macaddr(2)
   Incr Lw : Buffer(lw) = My_b_macaddr(3)
   Incr Lw : Buffer(lw) = My_b_macaddr(4)
   Incr Lw : Buffer(lw) = My_b_macaddr(5)
   Incr Lw : Buffer(lw) = My_b_macaddr(6)

   Incr Lw : Buffer(lw) = &HFF                              'insert end command
   Call Ip_set_packet_length(lw)
   Call Ip_header_checksum
   Call Udp_set_packet_length(lw)
   Call Udp_checksum
   Call Enc28j60packetsend(lw)

   #if Debug_dhcp > 0
   Print
   Print "====================================================================="
   Print "  DHCP Request sent to IP "
   Call Print_ip(ip_b_destaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_dest_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_dhcp > 2
   Call Eth_dump_header
   Call Ip_dump_header
   Call Udp_dump_header
   Call Dhcp_dump_frame
#endif

End Sub

'-------------------------------------------------------------------------------
'  DHCP Acknowledgement received
'-------------------------------------------------------------------------------
Sub Dhcp_received_ack
#if Debug_dhcp > 0
   Print
   Print "====================================================================="
   Print "  DHCP Ack received from IP ";
   Call Print_ip(ip_b_srcaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_src_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_dhcp > 2
   Call Eth_dump_header
   Call Ip_dump_header
   Call Udp_dump_header
   Call Dhcp_dump_frame
#endif

  My_b_ipaddr(1) = Dhcp_b_yiaddr(1)                         'received ip lease --> my IP
  My_b_ipaddr(2) = Dhcp_b_yiaddr(2)
  My_b_ipaddr(3) = Dhcp_b_yiaddr(3)
  My_b_ipaddr(4) = Dhcp_b_yiaddr(4)
#if Debug_dhcp > 1
  Print "DHCP-Ack: IP-Address now: " ; My_b_ipaddr(1) ; "." ; My_b_ipaddr(2) ; "." ; My_b_ipaddr(3) ; "." ; My_b_ipaddr(4)
#endif

  Call Dhcp_parse_options
  Dhcp_status = Dhcp_status_bound
#if Debug_dhcp > 1
  Print "  DHCP Status changed to BOUND"
#endif
' Wenn mehr als ein net-io im Netz ist, muss die Dhcp_transaction_id unterschiedlich sein!
' Michael, six1
' alt -->  Dhcp_transaction_id = 0
  Call Dhcp_create_new_xid

  #if Include_lcd = 1
  Cls
  Locate 1 , 1
  Lcd My_b_ipaddr(1) ; "." ; My_b_ipaddr(2) ; "." ; My_b_ipaddr(3) ; "." ; My_b_ipaddr(4)
  Locate 2 , 1
  Lcd "DHCP  "
  #endif

  #if Debug_dhcp = 1
  Print
  Print "Network Settings set by DHCP..."
  Print " IP-Address: " ; My_b_ipaddr(1) ; "." ; My_b_ipaddr(2) ; "." ; My_b_ipaddr(3) ; "." ; My_b_ipaddr(4)
  Print "MAC-Address: " ; Hex(my_b_macaddr(1)) ; "-" ; Hex(my_b_macaddr(2)) ; "-" ; Hex(my_b_macaddr(3)) ; "-" ; Hex(my_b_macaddr(4)) ; "-" ; Hex(my_b_macaddr(5)) ; "-" ; Hex(my_b_macaddr(6))
  #endif
End Sub

'-------------------------------------------------------------------------------
'  DHCP Negative Acknowledgement received
'-------------------------------------------------------------------------------
Sub Dhcp_received_nak
#if Debug_dhcp > 0
   Print
   Print "====================================================================="
   Print "  DHCP Nak received from IP ";
   Call Print_ip(ip_b_srcaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_src_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_dhcp > 2
   Call Eth_dump_header
   Call Ip_dump_header
   Call Udp_dump_header
   Call Dhcp_dump_frame
#endif

   Dhcp_status = Dhcp_status_init
#if Debug_dhcp > 1
  Print "  DHCP Status set to INIT"
#endif

End Sub

'-------------------------------------------------------------------------------
'  DHCP find option
'-------------------------------------------------------------------------------
Function Dhcp_find_option(byval Opt As Byte) As Word
Local Lw As Word
Local Lx As Word
   Lw = Dhcp_options_start
   Do
      Select Case Buffer(lw)
         Case 0                                             'Padding
            Incr Lw
         Case Opt
            Dhcp_find_option = Lw
            Exit Sub
         Case &HFF                                          'End of Options
            Dhcp_find_option = 0
            Exit Sub
         Case Else
            Lx = Buffer(lw + 1)
            Lw = Lw + 2
            Lw = Lw + Lx
      End Select
   Loop
End Function

'-------------------------------------------------------------------------------
'  DHCP parse options
'-------------------------------------------------------------------------------
Sub Dhcp_parse_options
Local Lw As Word
Local Llen As Word
Local Lo As Byte
   Lw = Dhcp_options_start
   Do
      Llen = Buffer(lw + 1)
      Lo = Buffer(lw)
      Select Case Buffer(lw)
         Case 0                                             'Padding
            Incr Lw
         Case 1                                             'Subnet Mask
            If Llen = 4 Then
               My_b_subnetmask(1) = Buffer(lw + 2)
               My_b_subnetmask(2) = Buffer(lw + 3)
               My_b_subnetmask(3) = Buffer(lw + 4)
               My_b_subnetmask(4) = Buffer(lw + 5)
            End If
         Case 3                                             'Routers
            If Llen >= 4 Then
               My_b_defaultgateway(1) = Buffer(lw + 2)
               My_b_defaultgateway(2) = Buffer(lw + 3)
               My_b_defaultgateway(3) = Buffer(lw + 4)
               My_b_defaultgateway(4) = Buffer(lw + 5)
#if Debug_dhcp > 1
  Print "DHCP-Ack: Default GW now: " ; My_b_defaultgateway(1) ; "." ; My_b_defaultgateway(2) ; "." ; My_b_defaultgateway(3) ; "." ; My_b_defaultgateway(4)
#endif
            End If
' Freesol: Keine NTP-Server-Vernderung mehr mglich
'#if Include_ntp = 1
'         Case 4                                             'Time Servers
'            If Llen >= 4 Then
'               Ntp_b_server(1) = Buffer(lw + 2)
'               Ntp_b_server(2) = Buffer(lw + 3)
'               Ntp_b_server(3) = Buffer(lw + 4)
'               Ntp_b_server(4) = Buffer(lw + 5)
'#if Debug_dhcp > 1
'  Print "DHCP-Ack: NTP server now: " ; Ntp_b_server(1) ; "." ; Ntp_b_server(2) ; "." ; Ntp_b_server(3) ; "." ; Ntp_b_server(4)
'#endif
'            End If
'#endif
#if Include_dns = 1
         Case 6                                             'Domain Name Servers
            If Llen >= 4 Then
               Dns_b_nameserver(1) = Buffer(lw + 2)
               Dns_b_nameserver(2) = Buffer(lw + 3)
               Dns_b_nameserver(3) = Buffer(lw + 4)
               Dns_b_nameserver(4) = Buffer(lw + 5)
#if Debug_dhcp > 1
  Print "DHCP-Ack: Nameserver now: " ; Dns_b_nameserver(1) ; "." ; Dns_b_nameserver(2) ; "." ; Dns_b_nameserver(3) ; "." ; Dns_b_nameserver(4)
#endif
            End If
#endif
         Case 51                                            'IP Address Lease Time
            If Llen = 4 Then
               Dhcp_lease_time = Bytes2long(buffer(lw + 5) , Buffer(lw + 4) , Buffer(lw + 3) , Buffer(lw + 2))
            End If
         Case 53                                            'DHCP Opcode (already parsed in packet filter)
         Case 54                                            'DHCP Server Identification
            If Llen = 4 Then
               Dhcp_b_recent_server_ip(1) = Buffer(lw + 2)
               Dhcp_b_recent_server_ip(2) = Buffer(lw + 3)
               Dhcp_b_recent_server_ip(3) = Buffer(lw + 4)
               Dhcp_b_recent_server_ip(4) = Buffer(lw + 5)
#if Debug_dhcp > 1
  Print "DHCP-Ack: DHCP Servr now: " ; Dhcp_b_recent_server_ip(1) ; "." ; Dhcp_b_recent_server_ip(2) ; "." ; Dhcp_b_recent_server_ip(3) ; "." ; Dhcp_b_recent_server_ip(4)
#endif
            End If
         Case 58                                            'Renewal (T1) Time Value
            If Llen = 4 Then
               Dhcp_renew_time = Bytes2long(buffer(lw + 5) , Buffer(lw + 4) , Buffer(lw + 3) , Buffer(lw + 2))
            End If
         Case 59                                            'Rebinding (T2) Time Value
            If Llen = 4 Then
               Dhcp_rebinding_time = Bytes2long(buffer(lw + 5) , Buffer(lw + 4) , Buffer(lw + 3) , Buffer(lw + 2))
            End If
         Case &HFF                                          'End of Options
            #if Include_arp = 1
            Call Arp_enqueue_ip(my_b_defaultgateway(1))
            #endif
#if Include_ntp = 1
            #if Include_arp = 1
            Call Arp_enqueue_ip(ntp_b_server(1))
            #endif
#endif
            #if Include_arp = 1
            Call Arp_enqueue_ip(dns_b_nameserver(1))
            Call Arp_enqueue_ip(dhcp_b_recent_server_ip(1))
            #endif
            Exit Sub
         Case Else
      End Select
      If Buffer(lw) > 0 Then
         Lw = Lw + 2
         Lw = Lw + Llen
      End If
   Loop

End Sub

'-------------------------------------------------------------------------------
'  DHCP create new transaction ID
'-------------------------------------------------------------------------------
Sub Dhcp_create_new_xid
Local Lw As Word
   Dhcp_transaction_id = Rnd(&Hffff)
   Shift Dhcp_transaction_id , Left , 16
   Lw = Rnd(&Hffff)
   Dhcp_transaction_id = Dhcp_transaction_id + Lw
End Sub

'******************************************************************************
' Dump DHCP Frame
'******************************************************************************

#if Debug_dhcp > 2
Sub Dhcp_dump_frame
Local Lw As Word
Local Llen As Word
Local Li As Integer
Local Ls As String * 16
'Local Lw As Word
    Print "--------------------------------------------------------------------"
    Print "  DHCP Frame (" ; "??" ; " Bytes)                                        "
    Print "--------------------------------------------------------------------"
    Print "    Opcode: " ; : Call Print_byte(dhcp_b_opcode , Crlf)
    Print "   HW Type: " ; : Call Print_byte(dhcp_b_hwtype , Crlf)
    Print "   HW size: " ; : Call Print_byte(dhcp_b_hwlen , Crlf)
    Print "      Hops: " ; : Call Print_byte(dhcp_b_hops , Crlf)
    Print "       Xid: " ; : Call Print_long(dhcp_l_transaction_id , Crlf)
    Print "      Secs: " ; : Call Print_word(dhcp_w_secs , Crlf)
    Print "     Flags: " ; : Call Print_word(dhcp_w_flags , Crlf)
    Print " Client IP: " ; : Call Print_ip(dhcp_b_ciaddr(1) , Crlf)
    Print "   Your IP: " ; : Call Print_ip(dhcp_b_yiaddr(1) , Crlf)
    Print " Server IP: " ; : Call Print_ip(dhcp_b_siaddr(1) , Crlf)
    Print "  Relay IP: " ; : Call Print_ip(dhcp_b_giaddr(1) , Crlf)
    Print " Client HW: " ; : Call Print_mac(dhcp_b_chaddr(1) , Crlf)
    Ls = ""
    For Li = 1 To 64
        Ls = Ls + Chr(dhcp_b_sname(li))
    Next Li
    Print "Servername: " ; Ls
    Print "  Bootfile: " ; "<unused>"
    Print "DhcpCookie: " ; : Call Print_long(dhcp_l_dhcp_cookie , Crlf)
    Lw = Dhcp_options_start
    Do
      If Buffer(lw) = &HFF Then
         Print "    Option: End"
         Exit Do
      End If
      If Buffer(lw) <> 0 Then
         Print "    Option: " ; : Call Print_byte(buffer(lw) , No_crlf) : Print " at Buffer(" ; Lw ; ")"
         Llen = Buffer(lw + 1)
         Print "    Length: " ; Llen
         Print "     Value: " ;
         Lw = Lw + 2
         For Li = 1 To Llen
            Print Hex(buffer(lw)) ; " ";
            Incr Lw
         Next Li
         Print
      End If
    Loop
    End Sub
#endif